<?
/*

 ***************************************************************************
 * Copyright (C) 2001 - Koulikov Alexey - ak@ita-studio.com                *
 *                                                                         *
 * This program is commercial software; you can not redistribute it and/or *
 * sell it under the terms of the Public Software License                  *
 * as published by ITA Studio;                                             *
 *                                                                         *
 * This program is distributed in the hope that it will be useful,         *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 * Public Software License, included with the distributive                 *
 * for more details.                                                       *
 *                                                                         *
 * You should have received a copy of the Public Software License,         *
 * view it here: http://www.ita-studio.com/forum/en/license.php            *
 ***************************************************************************

*/
  class pageSplit{

      //set up variables
      var $max;
      var $block_size;
      var $current_block;
      var $main_link;

      //Object Constructor...
      function pageSplit($m,$block,$link,$toshow=20){
          //correct current block...
          if($block > $m){
              $block = $m - $toshow;}
      
          $this->setMax($m);
          $this->setBlockSize($toshow);
          $this->setCurrentBlock($block);
          $this->setMainLink($link);
      }
      
      //output function
      function showLine($colspan = 3){
          if($this->getMax() > $this->getBlockSize()){
              $temp = $this->rebuild($this->getMainLink());
	          echo $this->show_line($this->getMax(), $this->getBlockSize(), $temp, $this->getCurrentBlock(),$colspan);
          }
      }
      
      //all the SET functions...
      function setMax($n){
          $this->max=$n;
      }
      
      function setBlockSize($n){
          $this->block_size=$n;
      }
      
      function setCurrentBlock($n){
          $this->current_block=$n;
      }
      
      function setMainLink($n){
          $this->main_link=$n;
      }
      
      //all the GET functions
      function getMax(){
          return $this->max;
      }
      
      function getBlockSize(){
          return $this->block_size;
      }
      
      function getCurrentBlock(){
          return $this->current_block;
      }
      
      function getMainLink(){
          return $this->main_link;
      }
      
      /*
	    This function will rebuild any GET variables passed to a page
	    in the form of a link. Eg. adverts.php?dir=12&cir=13 will be
	    constructed from $curr being 'adverts.php' and $vars being the
	    global $HTTP_GET_VARS array.

	    Version: 1.0
	    Purpose: To use in the Shortcut Nav Bar generation.
      */
      function rebuild($curr){
        GLOBAL $HTTP_GET_VARS;
        $vars = $HTTP_GET_VARS;
 	    $s = sizeof($vars);
	    $t = $curr;
	    $t .= "?";
	    if($s>0){
          for($i = 0; $i<$s; $i++)
		  {
            if(key($vars)=="block"){
		      next($vars);
		      continue;
  		    }//end if key()

            $t .= key($vars) . "=";
            $t .= current($vars);
            $t .= "&";
            if(($i+1)<$s){
              next($vars);
            }
		  }//end for
	    }//end if s>0
	    return $t;
      }//end function


      /*
	    This fucntion will create the actual short cut navigation bar
	    based on the parameters passed to it. $max represents the max
	    number of elements to be accessed in the database, $div is the
	    step at which the line will operate, $link is most frequently
	    $php_self but any link can be specified, and finally $b is the
	    current block, to make the current selection stand out.

	    Version: 2.0
	    Purpose: To use in the Shortcut Nav Bar generation.

	    Updates from V 1.0 - Sliding Bar, shows 7 entities, and "slides"
	    the middle on request. All placed inside pretty tables.
      */
      function show_line($max, $div, $link, $b, $colspan){
        GLOBAL $lang, $DARK_IN, $TOP_IN, $TOP_IN_LIGHT, $BORDER_COLOR;
        
	    $rep = ceil($max / $div);
	    if($rep < 2){
	    }else{

		  $currentposition = round($b / $div);

		  if($currentposition<3){
			$minis = 0;
			$maxis = 5;
		  } else {
			$minis = $currentposition - 2;
			$maxis = $currentposition + 3;
		  }

		  if($maxis > $rep){
			$maxis = $rep;
			$minis = $maxis - 5;
			if($minis < 0){$minis = 0;}
		  }

          if(($b==0)||(($max-$div)<$b)){
              $perc = round(100/($maxis - $minis + 1));
          }else{
  		      $perc = round(100/($maxis - $minis + 2));
          }

          //header...
          ?>
            <tr>
            <td colspan=<?=$colspan?> bgcolor="<?=$TOP_IN_LIGHT?>" class="group_name" align="center">
          <?

          //show PREVIOUS...
		  if($b>0){
			$temp = $b - $div;
            ?>
               <a href="<?=$link?>block=<?=$temp?>"><?=$lang['PREV']?></a>
            <?
		  }

          $diff = $maxis - $minis;
          if(($diff==2)||($diff>4)){
              $perc++;
          }
            
          //show CONTENTS
		  for($i = $minis; $i<$maxis; $i++){
			$temp = $i * $div;
			$t = $i + 1;
			$tm = $t*$div - $div + 1;
			$tc = $t*$div;

			if($tc > $max){
				$tc = $max; }

			if(round($b / $div)==$i){
                echo $tm;
                echo " - ";
                echo $tc;
			} else {
              ?>
                &nbsp;<a href="<?=$link?>block=<?=$temp?>"><?=$tm?> - <?=$tc?></a>&nbsp;
              <?
			}
		  } //end for


          //show NEXT...
		  if($b<($max-$div)){
			$temp = $b + $div;
            ?>
              <a href="<?=$link?>block=<?=$temp?>"><?=$lang['NEXT']?></a>
            <?
		  }

          //footer
          ?>
            </td>
            </tr>
          <?
        }
      }//end function
  }//end class pageSplit
	
	if(!isset($block)){
		$block = 0;
	}
?>
