<?php
/*
 guestbook.php - main guestbook modul

 Copyright (C) 2001 Achim Winkler <achim@lkcc.org>

 This is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This software is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this package; see the file COPYING.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
*/

	function ShowEntries($page, $entrypos) {
		global $phrase;
		
		if (!file_exists("output.php")) die ("Can't open output.php!");
		include("output.php");
		$output = new COutput($page, $entrypos, $phrase);
		$output->Output_All();
		unset($output);
		$action = "show";
	}


	function NewEntry() {
		global $newname, $newmail, $newurl, $newicq, $newaim, $newtext;
		
		if (!file_exists("tools.php")) die ("Can't open tools.php!");
		include("tools.php");
		if (!file_exists("input.php")) die ("Can't open input.php!");
		include("input.php");
		$input = new CInput();
		$input->Formular_Show(0, $newname, $newmail, $newurl, $newicq, $newaim, $newtext);
		unset($input);
	}


	function WriteEntry($emotion = "no", $preview = 0, $write = 0, $random = -1) {
		global $newname, $newmail, $newurl, $newicq, $newaim, $newtext;
		
		if (!file_exists("tools.php")) die ("Can't open tools.php!");
		include("tools.php");
		if (!file_exists("input.php")) die ("Can't open input.php!");
		include("input.php");
		$input = new CInput($emotion);
		if ($preview != 0 && $write != 0) {
			$input->Write_Data($newname, $newmail, $newicq, $newaim, $newurl, $newtext, $random);
			header ("Location: guestbook.php?act=show");
		}
		elseif ($preview != 0) {
			if (!file_exists("preview.php")) die ("Can't open preview.php!");
			include("preview.php");

			$preview = new CPreview($emotion);

			$preview->Show_Preview($newname, $newmail, $newicq, $newaim, $newurl, $newtext);
		}
		else {
			$input->Write_Data($newname, $newmail, $newicq, $newaim, $newurl, $newtext, $random);
		}
		unset($input);
	}

	
	function SearchEntry($next = "no") {
		global $what, $phrase, $page;
		
		if (!file_exists("search.php")) die ("Can't open search.php!");
		include("search.php");
		$search = new CSearch();
		
		if (!isset($what)) {
			$search->SearchScreen($phrase, $page, $next);
		} else {
			$search->Search($phrase, $page, $next);
		}	
	}


	ob_start();

	error_reporting(0);

	if (!ignore_user_abort()) ignore_user_abort(true);

	#administration in progress?
	if (!file_exists("config.php")) die ("Can't open config.php!");
	include("config.php");
	
	while (file_exists($datapath."/lock.lck")) {
		usleep(500000);
		$i++;
		if ($i > 9) {
			echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">";
			echo "<HTML><HEAD><TITLE>Guestbook</TITLE><LINK HREF=\"guestbook.css\" REL=\"stylesheet\" TYPE=\"text/css\"></HEAD>";
			echo "<BODY>";
			echo "<TABLE BORDER=\"0\" VALIGN=\"middle\" WIDTH=\"100%\" HEIGHT=\"100%\">";
			echo "<TR><TD ALIGN=\"center\">";
			echo "<FONT SIZE=\"5\" COLOR=\"E01010\">Administration activities in progress.<BR>Please try it later again!</FONT>";
			echo "</TD></TR></TABLE></BODY></HTML>";
		}
	}

	if (!isset($act) || $act == "" || $act == "show") {
		#show guestbook
		if (!isset($page)) $page = 1;
		if (!isset($entrypos)) $entrypos = -1;
		if (!isset($phrase)) $phrase = "";
		ShowEntries($page, $entrypos);
	}
	elseif ($act == "new") {
		#new guestbook entry
		if (!isset($newname)) $newname = "";
		if (!isset($newmail)) $newmail = "";
		if (!isset($newurl) || $newurl == "") $newurl = "http://";
		if (!isset($newicq)) $newicq = "";
		if (!isset($newaim)) $newaim = "";
		if (!isset($newtext)) $newtext = "";
		NewEntry();
	}
	elseif ($act == "write") {
		if ($pre == "yes" && isset($presave)) {
			#save the preview data
			WriteEntry($emotion, 1, 1, $random);
		}
		elseif ($pre == "yes") {
			#save data with preview
			WriteEntry($emotion, 1);
		} else {
			#save data without preview
			WriteEntry($emotion);
			header ("Location: guestbook.php?act=show");
		}
	}
	elseif ($act == "search") {
		if (!isset($next)) $next = "no";
		if (isset($entrypos)) $next = "yes";
		if ($next == "no") $page = 1;
		if (!isset($phrase) || $phrase == "") $phrase = "";
		
		SearchEntry($next);
	}

	ob_end_flush();

?> 