<?php
/*
 * The phpShop Parser
 *
 * Copyright (c) Edikon Corporation.  All rights reserved.
 * Distributed under the phpShop Public License (pSPL) Version 1.0.
 *                    
 * $Id: index.php3,v 1.20 2000/11/01 15:34:33 pfmartin Exp $
 *
 */ 
// EDIT

$base_dir = "/home/httpd/phpshop/";
unset($auth);


// DO NOT EDIT FROM HERE ON
//**************************************************
require($base_dir. "etc/phpshop.cfg");
require($base_dir . "db/db_mysql.inc");
require(MODROOT."admin/lib/ps_main.inc");
require($base_dir . "modules/admin/lib/ps_include.inc");
// Timer Start
if (DEBUG) {
  $start = utime();
}

// Load module definitions
$module = array();
$label = array();


$db = new ps_DB;


// Instantiate db and session class
$sess = new ps_session;
$perm = new ps_perm;
$vars = array();

// In case someone tries to be sneaky
$run_dir=0;
$run_func=0;

// Set default language as specified in phpshop.cfg
if (!isset($lang)) {
  $lang = LANGUAGE;
  $sess->register("lang");
}	


// Save current page call
$this_page=$page;

// Register previous page
if (!isset($last_page)) {
  $sess->register("last_page");
}
// Register the cart
if (!isset($cart)) {
  $cart = array();
  $cart["idx"] = 0;
  $sess->register("cart");
}
// Register the auth array
if (!isset($auth)) {
  $auth = array();
  $sess->register("auth");
}


// Get Function Permissions
// Sets $run_func if func is registered and have permission
// Displays error if function is not registered
if ($func) {
  $func_list = $ps_function->get_function($func);
  if ($func_list) {
    if ($perm->check($func_list["perms"])) {
      $run_func = 1;
      $func_perms = $func_list["perms"];
      $func_class = $func_list["class"];
      $func_method = $func_list["method"];      
    }
    else {
      $error_type = "Insufficient Access Rights";
      $error = "You do not have permission to execute $func.";
      $page = ERRORPAGE;          
      $run_func = 0;
    }
  }
  else {
    $error_type = "Function Not Registered";
    $error = "$func is not a valid phpShop function.";
    $page = ERRORPAGE;    
    $run_func = 0;
  }
}

// Get Page/Directory Permissions
// Sets $run_dir if we can run it
// Displays error if directory is not registered, 
// no permission, or file does not exist
if (!$page) {
  $page = HOMEPAGE;
}

$modulename = dirname("$page");
$pagename = basename("$page");

if (empty($modulename)) {
  $modulename=dirname(HOMEPAGE);	
  $pagename = basename(HOMEPAGE);
}

$dir_list = $ps_module->get_dir($modulename);
if ($dir_list) {
  if ($perm->check($dir_list["perms"])) {
    if (!file_exists(MODROOT.$modulename."/html/".$pagename.".ihtml")) {
      $error_type = "Page Does Not Exist";
      $error =  "Given filename does not exist. Cannot find file:<BR>";
      $error .= $modulename."/html/".$pagename.".ihtml";
      $page = ERRORPAGE;
    }
  }
  else {
    if ($func != "userLogin") {
      $error = "";     
      $page = $last_page;
      $vars["login"]=1;
    }
  }

  // Load MODULE
  $module = load_module($modulename);
  require(MODROOT.$modulename."/lib/ps_include.inc");
  $label = load_labels($modulename);  
}
else {
  $error_type = "Module Not Registered";
  $error = "$modulename is not a valid phpShop module.";
  $page = ERRORPAGE;
}

// Copy the vars and register them into the session
if ($HTTP_POST_VARS) {
  $vars = $HTTP_POST_VARS;
  
  // Fix for php4 image upload problem.  The error
  // is currently due to php4 not setting the http_post_vars
  // array with the file input field value.
  $vars["vendor_full_image"] = $vendor_full_image;
  $vars["vendor_full_image_name"] = $vendor_full_image_name;
  $vars["vendor_full_image_size"] = $vendor_full_image_size;

  $vars["product_full_image"] = $product_full_image;
  $vars["product_full_image_name"] = $product_full_image_name;
  $vars["product_full_image_size"] = $product_full_image_size;       

  $vars["product_thumb_image"] = $product_thumb_image;
  $vars["product_thumb_image_name"] = $product_thumb_image_name;
  $vars["product_thumb_image_size"] = $product_thumb_image_size;       
  // End fix
}
elseif ($HTTP_GET_VARS) {
  $vars = $HTTP_GET_VARS;
} 
  

// Run the function if we have permission
if ($run_func) {

  
  $q = "SELECT module.module_name FROM module,function WHERE ";
  $q .= "module.module_id=function.module_id AND ";
  $q .= "function.function_method='$func_method' AND ";
  $q .= "function.function_class='$func_class'";
  $db->query($q);
  $db->next_record();

  // Load class definition file
  eval(load_class($db->f("module_name"), $func_class));
  $string = "\$" . $func_class . " = new " . $func_class . ";";
  eval($string);
  
  // RUN THE FUNCTION
  $cmd = "\$ok = \$" . $func_class . "->" . $func_method . "(\$vars);";
  eval($cmd);
  if (!$ok) {
    if ($vars["login"] == "1") {
      $error = $vars["error"];
      $vars["login"]=1;
    }
    else {
      $no_last =1;
      $page = $last_page;
      $error = $vars["error"];
    }
  }
  else {
    $no_last = 0;
    $error="";
    $page = $vars["page"];
  }
}

// LOAD PAGE

// If this is a login, then load the approprate module information based on wher
// the login page is.
if ($vars["login"] == "1" || $page==LOGINPAGE || !$perm->check($dir_list["perms"])) {
  $last_page = $this_page;
  $page = LOGINPAGE;
  $modulename = dirname($page);
  $module = load_module($modulename);
  require(MODROOT.$modulename."/lib/ps_include.inc");
  $label = load_labels($modulename);
}

if (!$no_last) {
  $last_page = $this_page;
}
if (!$page) {
  $page = HOMEPAGE;
}
// Show the page!
$modulename = dirname($page);
$pagename = basename($page) . ".ihtml";

// Load global file
require(MODROOT."/templates/global.inc");

// Load language file for this module

if (file_exists(MODROOT.$modulename."/lib/lang_$lang.inc")) {
  include(MODROOT.$modulename."/lib/lang_$lang.inc");
}
else {
  //Default to english if not set.
  include(MODROOT.$modulename."/lib/lang_eng.inc");
}

// Load Header
if ($module[$modulename]["module_header"] && $print!="1") {
  include(MODROOT."/templates/".$module[$modulename]["module_header"]);
}

// Load PAGE
include(MODROOT.$modulename."/html/".$pagename);

// Load footer
if ($module[$modulename]["module_footer"] && $print!="1") {
  include(MODROOT."/templates/".$module[$modulename]["module_footer"]);
}

// Save the session variables for the next run
$sess->save();

if (SHOWVERSION) {
  include(DOCROOT ."/VERSION.txt");
}
// Set debug option on/off
if (DEBUG) {
  $end = utime();
  $runtime = $end - $start;
  $messages = dirname(DEBUGPAGE);
  $pagename = basename(DEBUGPAGE) . ".ihtml";  
  include(MODROOT.$messages."/html/".$pagename);
}

?>
