<?php
/*
 *
 * Copyright (c) Edikon Corporation.  All rights reserved.
 * Distributed under the phpShop Public License (pSPL) Version 1.0.
 *
 * $Id: ps_intershipper.inc,v 1.8 2000/09/20 04:03:01 reallost1 Exp $
 *
 */

/************************************************************************
*
* CLASS DESCRIPTION
*
* ps_ISship
*
* This class contains all the methods required to build, validate, and 
* submit quote requests to the InterShipper server.
*
* propeties:
* 	error		=	last error that occurred.
*
* methods:
* 	refresh		=	refreshes the vendors database of shipping methods
*	ping		=	pings the InterShipper server for a response
*	update		=	updates the vendors database of shipping methods
*				with changes.  Called by ISship_form.ihtml.
*	validate	=	validates that the module is activated and has
*				authentication information.
*	get_weight	=	returns the current products weight in ounces
*	fetch_quote	=	retreives and validates all information required to
*				generate a quote request, and then passes the data
*				to the ps_intershipper class which generates and
*				submits the request to the InterShipper server.
*				fetch_quote() then stores the quote and the current
*				state in session variables IS_quote & IS_check.
*	default_method	=	An empty method that can be used to calculate a
*				default shipping calculation method.
*
*
*************************************************************************/
class ps_intershipper {
  var $classname = "ps_intershipper";
  var $error;

  /* The correlation between carrier ID and carrier CODE needs to be made
   * here.  Intershipper returns the carrier ID in the return
   * quote, but we need to send the carrier CODE in the request.  As
   * Intershipper adds more carriers, this list will need to be updated.
   */

  var $carriers = array("918854856"             =>      "RPS",
                        "452235464"             =>      "ANX",
                        "919801409"             =>      "ABX",
                        "918593305"             =>      "USPS",
                        "1044186586"            =>      "FDX",
                        "919202226"             =>      "DHL",
                        "908801501"             =>      "UPS",
                        "966637132"             =>      "EWW",
			"927757907"		=>	"BAX");


  /**************************************************************************
  ** name: refresh()
  ** created by: Matt Oberpriller
  ** description: Refresh database with Intershipper shippers.
  ** parameters: None
  ** returns: Boolean
  ***************************************************************************/  
  function refresh() {
    global $ps_vendor_id;

    /* validate module activation and InterShipper authorization */
    if (!$this->validate()) {
      return false;
    }

    /* check InterShipper server status */
    if (!$this->ping()) {
      return false;
    }

    eval(load_class("ISshipping", "Intershipper"));
    $Intershipper = new InterShipper();
    $db = new ps_DB;

    $timestamp = time();

    /* retrieve both light and heavy shipping methods */

    $weight[] = 200;
    $weight[] = 1;

    /* Seed Intershipper API authentication variables and
     * give dummy zip codes and weight so that intershipper
     * will return all ship methods
     */

    /* purge the current shipper database */

    $q  = "DELETE FROM ISshipping ";
    $q .= "WHERE vendor_id='$ps_vendor_id'";
    $db->query($q);

    reset($weight);
    while(list($Wkey,$Wval)=each($weight)) {
      $Intershipper->Request['carriers'] = "ALL";
      $Intershipper->Request['email'] = IS_EMAIL;
      $Intershipper->Request['password'] = IS_PASSWORD;
      $Intershipper->Request['Opostalcode'] = "30307";
      $Intershipper->Request['Dpostalcode'] = "21201";
      $Intershipper->Request['weight'] = intval($Wval);
      $Intershipper->Request['weightuom'] = "PO";

      /* Get the quote for all shippers */

      if (!$Intershipper->Quote(60)) {
        $this->error = $Intershipper->Last_Error;
        return false;
      } else {

        $result=$Intershipper->getQuote();
        reset($result);
        while (list($key,$val)=each($result)) {
          reset($this->carriers);
          while(list($Ckey,$Cval)=each($this->carriers)) {
            if (strcmp(trim($result[$key]["carrierid"]),trim($Ckey)) == 0)
              $result[$key]["carriercode"] = $Cval;
          }
          $q  = "SELECT * FROM ISshipping ";
          $q .= "WHERE vendor_id='$ps_vendor_id' ";
          $q .= "AND ship_method_code='" . $result[$key]["methodcode"] . "'";
          $db->query($q);
          if (($Wval == 200) && ($db->num_rows() == 0)) {
            $i  = "INSERT INTO ISshipping (ship_carrier_code,ship_carrier_id,ship_carrier_name,ship_method_code,";
            $i .= "ship_method_name,ship_publish,ship_handling_charge,ship_lead_time,cdate,vendor_id,ship_heavy) ";
            $i .= "VALUES ('" . $result[$key]["carriercode"] . "','" . $result[$key]["carrierid"] . "','";
            $i .= $result[$key]["carriername"] . "','" . $result[$key]["methodcode"] . "','";
            $i .= $result[$key]["methodname"] . "','N','0','0','";
            $i .= $timestamp . "','" . $ps_vendor_id . "','Y')";
            $db->query($i);
          } elseif ($db->num_rows() == 0) {
            $i  = "INSERT INTO ISshipping (ship_carrier_code,ship_carrier_id,ship_carrier_name,ship_method_code,";
            $i .= "ship_method_name,ship_publish,ship_handling_charge,ship_lead_time,cdate,vendor_id) VALUES ('";
            $i .= $result[$key]["carriercode"] . "','" . $result[$key]["carrierid"] . "','";
            $i .= $result[$key]["carriername"] . "','" . $result[$key]["methodcode"] . "','";
            $i .= $result[$key]["methodname"] . "','N','0','0','";
            $i .= $timestamp . "','" . $ps_vendor_id . "')";
            $db->query($i);
          }
        }
      }
    }
    return true;
  }

  /**************************************************************************
  ** name: ping()
  ** created by: Matt Oberpriller
  ** description: Ping the Intershipper server and get shipper response time.
  ** parameters: None
  ** returns: Array $status[$carrier][$response]
  ***************************************************************************/  
  function ping() {

    /* validate module activation and InterShipper authorization */
    if (!$this->validate()) {
      return false;
    }

    eval(load_class("ISshipping", "Intershipper"));
    $Intershipper = new InterShipper();

    /* Seed Intershipper API authentication variables and
     * give dummy weight
     */

    $Intershipper->Request['carriers'] = "ALL";
    $Intershipper->Request['email'] = IS_EMAIL;
    $Intershipper->Request['password'] = IS_PASSWORD;
    $Intershipper->Request['weight'] = "1.1";

    /* Get carrier response times */

    if (!$Intershipper->Quote(60)) {
      $this->error = $Intershipper->Last_Error;
      return false;
    } else {
      $ping=$Intershipper->RequestData;

      $pattern = "/<CARRIER .*?<\/CARRIER>/i";
      $carriercount = preg_match_all($pattern, $ping, $carriers, PREG_SET_ORDER);
      for($idx = 0; $idx < $carriercount; $idx ++)
      {
        $pattern = "/<CARRIER [^>]*NAME[ ]*=[ ]*\"([^\"]*)/i";
        preg_match($pattern, $carriers[$idx][0], $temp);
        $carrier = $temp[1];

        $pattern = "/<CARRIER [^>]*ELAPSEDTIME[ ]*=[ ]*\"([^\"]*)/i";
        preg_match($pattern, $carriers[$idx][0], $temp);
        $response = $temp[1];

        $status[$carrier] = $response;
      }
    }
    return($status);
  }

  /**************************************************************************
  ** name: update()
  ** created by: Matt Oberpriller
  ** description: Update shipping_method with changes.
  ** parameters: HTTP Post vars - usually $vars
  ** returns: Boolean
  ***************************************************************************/  
  function update(&$d) {
    global $ps_vendor_id;

    $timestamp = time();
    $db=new ps_DB;

    /* We will check for an array of ship methods to be updated
     * if it's not an array, we'll update just one record.
     */

    if (count($d["ship_method_id"])) {
      reset($d["ship_method_id"]);
      while(list($key,$val)=each($d["ship_method_id"])) {
        $q  = "UPDATE ISshipping SET ";
        $q .= "ship_carrier_id='" . $d["ship_carrier_id"][$key] . "',";
        $q .= "ship_carrier_code='" . $d["ship_carrier_code"][$key] . "',";
        $q .= "ship_carrier_name='" . $d["ship_carrier_name"][$key] . "',";
        $q .= "ship_method_code='" . $d["ship_method_code"][$key] . "',";
        $q .= "ship_method_name='" . $d["ship_method_name"][$key] . "',";
        $q .= "ship_publish='" . $d["ship_publish"][$key] . "',";
        $q .= "ship_handling_charge='" . $d["ship_handling_charge"][$key] . "',";
        $q .= "ship_handling_type='" . $d["ship_handling_type"][$key] . "',";
        $q .= "ship_lead_time='" . $d["ship_lead_time"][$key] . "',";
        $q .= "ship_msg_header='" . $d["ship_msg_header"][$key] . "',";
        $q .= "ship_msg_footer='" . $d["ship_msg_footer"][$key] . "',";
        $q .= "mdate='$timestamp' ";
        $q .= "WHERE ship_method_id='" . $d["ship_method_id"][$key] . "' ";
        $q .= "AND vendor_id='" . $ps_vendor_id . "'";

        $db->query($q);
      }
    } else {
      $q  = "UPDATE ISshipping SET ";
      $q .= "ship_carrier_id='" . $d["ship_carrier_id"] . "',";
      $q .= "ship_carrier_code='" . $d["ship_carrier_code"] . "',";
      $q .= "ship_carrier_name='" . $d["ship_carrier_name"] . "',";
      $q .= "ship_method_code='" . $d["ship_method_code"] . "',";
      $q .= "ship_method_name='" . $d["ship_method_name"] . "',";
      $q .= "ship_publish='" . $d["ship_publish"] . "',";
      $q .= "ship_handling_charge='" . $d["ship_handling_charge"] . "',";
      $q .= "ship_handling_type='" . $d["ship_handling_type"] . "',";
      $q .= "ship_lead_time='" . $d["ship_lead_time"] . "',";
      $q .= "ship_msg_header='" . $d["ship_msg_header"] . "',";
      $q .= "ship_msg_footer='" . $d["ship_msg_footer"] . "',";
      $q .= "mdate='$timestamp' ";
      $q .= "WHERE ship_method_id='" . $d["ship_method_id"] . "' ";
      $q .= "AND vendor_id='" . $ps_vendor_id . "'";

      $db->query($q);
    }
    return true;
  }

  /**************************************************************************
  ** name: get_weight()
  ** created by: Matt Oberpriller
  ** description: Calculate product weight in ounces
  ** parameters: product_id
  ** returns: weight in ounces
  ***************************************************************************/  
  function get_weight($pid) {
    global $ps_vendor_id;

    $db = new ps_DB;

    $q  = "SELECT * FROM product ";
    $q .= "WHERE product_id='$pid' ";
    $q .= "AND vendor_id='$ps_vendor_id'";
    $db->query($q);
    $db->next_record();

    if ($db->f("product_weight") == 0 && $db->f("product_parent_id")) {
       $q = "SELECT * from product WHERE product_id=";
       $q .= $db->f("product_parent_id");
       $db->query($q);
       $db->next_record();       
    }

    if ($db->f("product_weight") > 0) {
      if (eregi("LB",$db->f("product_weight_uom")) || eregi("PO",$db->f("product_weight_uom")))
        $weight = $db->f("product_weight") * 16;
      elseif (eregi("KG",$db->f("product_weight_uom")) || eregi("KILO",$db->f("product_weight_uom")))
        $weight = $db->f("product_weight") * 35.27396194958041;
      elseif (eregi("G",$db->f("product_weight_uom")))
        $weight = $db->f("product_weight") * 0.035273961949580414;
      elseif (eregi("OZ",$db->f("product_weight_uom")) || eregi("OU",$db->f("product_weight_uom")))
        $weight = $db->f("product_weight");
      else
        $this->error="Unknown weight UOM in product " . $db->f("product_sku");
    } else {
      $this->error="Weight not specified for product " . $db->f("product_sku");
    }

    if ($weight)
     return($weight);
    else
     return 0;
  }

  /**************************************************************************
  ** name: validate()
  ** created by: Matt Oberpriller
  ** description: Validate quote retreival
  ** parameters: none
  ** returns: boolean
  ***************************************************************************/  
  function validate() {
    /* verify that Intershipper module is activated and that 
     * we have authorization to make a request of
     * the Intershipper server.
     */

    if (!IS_ENABLE) {
      $this->error = "InterShipper module not activated.";
      return false;
    } elseif (!IS_EMAIL) {
      $this->error = "InterShipper authorization email address missing.";
      return false;
    } elseif (!IS_PASSWORD) {
      $this->error = "Intershipper authorization password missing.";
      return false;
    }
    return true;
  }

  /**************************************************************************
  ** name: fetch_quote()
  ** created by: Matt Oberpriller
  ** description: Retrieve shipping quotes from shipper
  ** parameters: HTTP Post vars - usually $vars
  ** returns: multidimensional array of rate, ship date, and delivery date
  **          by ship method ID.
  **
  **          $quote[$ship_method_id]["rate"]	=	method rate
  **          $quote[$ship_method_id]["sdate"]	=	method ship date
  **          $quote[$ship_method_id]["ddate"]	=	methods delivery date
  ***************************************************************************/  
  function fetch_quote(&$d) {
    global $ps_vendor_id;
    global $cart;
    global $IS_quote;
    global $IS_check;
    global $sess;
    $qvars = array();

    eval(load_class("ISshipping", "Intershipper"));
    $Intershipper = new InterShipper;

    $db = new ps_DB;

    /* Check for a ship to address. */

    if (!$d["user_info_id"]) {
      if (!$d["ship_to_info_id"]) {
        $d["error"] = "Ship to address required.";
        return False;
      } else {
        $shipto_id = $d["ship_to_info_id"];      
      }
    } else {
      $shipto_id = $d["user_info_id"];
    }

    /* If a quote already exists, check to see if cart, quote, or ship to
     * address has changed since last function call.  If not,
     * return the existing quote.
     */

    $status = serialize($cart) . serialize($IS_quote) . $shipto_id;
    if (is_array($IS_quote) && (strcmp($IS_check,$status) == 0))
      return($IS_quote);

    /* Set authorization information */

    $Intershipper->Request['email'] = IS_EMAIL;
    $Intershipper->Request['password'] = IS_PASSWORD;

    /* Get active carriers */

    $q  = "SELECT DISTINCT(ship_carrier_code) FROM ISshipping ";
    $q .= "WHERE ship_publish='Y' ";
    $q .= "AND vendor_id='$ps_vendor_id'";
    $db->query($q);
    while ($db->next_record()) {
      $carriers .= $db->f("ship_carrier_code") . "|";
    }
    $carriers = substr($carriers,0,(strlen($carriers)-1));
    $Intershipper->Request['carriers'] = $carriers;

    /* Calculate total weight of all products.  Since only one
     * unit of measure can be sent.  All product weights must
     * be converted into a single unit of measure.  I chose
     * ounces because I'm a stubborn American.
     */

    for($i = 0; $i < $cart["idx"]; $i++) {
      if(!($product_weight_arr = $this->get_weight($cart[$i]["product_id"]))) {
        $d["error"]=$this->error;
        //return false;
      } 
      $totalweight += $product_weight_arr * $cart[$i]["quantity"];
    }

    /* weights must be integers
     * and cannot be 0
     */

    if (($totalweight / 16) < 1) {
      $totalweight = ceil($totalweight);
      $uom = "OZ";
    } else {
      $totalweight = round($totalweight / 16);
      $uom = "LB";
    }

    $Intershipper->Request['weight'] = $totalweight;
    $Intershipper->Request['weightunits'] = $uom;

    /* Get customer destination info */

    $q  = "SELECT * FROM user_info ";
    $q .= "WHERE user_info_id='$shipto_id'";

    $db->query($q);
    $db->next_record();

    $Intershipper->Request['Daddress'] = $db->f("address_1");
    $Intershipper->Request['Dcity'] = $db->f("city");
    $Intershipper->Request['Dstate'] = $db->f("state");
    $Intershipper->Request['Dpostalcode'] = $db->f("zip");
    $Intershipper->Request['Dcountry'] = $db->f("country");
    $Intershipper->Request['Dresidential'] = "YES";

    /* Get vendor origin info */

    $q  = "SELECT * from vendor ";
    $q .= "WHERE vendor_id='$ps_vendor_id'";
    $db->query($q);
    $db->next_record();

    $Intershipper->Request['Oaddress'] = $db->f("vendor_address_1");
    $Intershipper->Request['Ocity'] = $db->f("vendor_city");
    $Intershipper->Request['Ostate'] = $db->f("vendor_state"); 
    $Intershipper->Request['Opostalcode'] = $db->f("vendor_zip");
    $Intershipper->Request['Ocountry'] = $db->f("vendor_country");
    $Intershipper->Request['Oresidential'] = "NO";

    /* Make our request */

    if (!$this->validate() || !$Intershipper->Quote(60)) {
      $qvars = $this->default_method();
    } else {
      $response=$Intershipper->getQuote();

      $q  = "SELECT * FROM ISshipping ";
      $q .= "WHERE ship_publish='Y' ";
      $q .= "AND vendor_id='$ps_vendor_id'";
      $db->query($q);

      while ($db->next_record()) {
        reset($response);
        while (list($key,$val)=each($response)) {
          if (strcmp(trim($db->f("ship_method_code")),trim($response[$key]["methodcode"])) == 0) {
            $rate = $response[$key]["rate"];

            /* calculate our handling charges */

            if (($db->f("ship_handling_charge") <> 0) &&  ($db->f("ship_handling_type") == "P"))
              $rate = $rate + ($rate * ($db->f("ship_handling_charge") / 100));
            elseif (($db->f("ship_handling_charge") <> 0) &&  ($db->f("ship_handling_type") == "F"))
              $rate = $rate + $db->f("ship_handling_charge");
            $rate = sprintf("%8.2f", $rate);

            /* calculate our ship date */

            $ship = time() + ($db->f("ship_lead_time") * 86400);

            /* calculate the arrival date */

            $date = split("/", $response[$key]["date"]);
            $time = split(":", $response[$key]["time"]);
            $month = $date[0];
            $day = $date[1];
            $year = $date[2];
            $hour = $time[0];
            $min = $time[1];
            $arrive = mktime($hour, $min, 0, $month, $day, $year);
            $arrive = $arrive + ($db->f("ship_lead_time") * 86400);

            /* we don't ship or deliver on weekends */

            if (strtoupper(date("D", $ship)) == "SAT") {
              $ship += (2 * 86400);
              $arrive += (2 * 86400);
            } elseif (strtoupper(date("D", $ship)) == "SUN") {
              $ship += 86400;
              $arrive += 86400;
            }
            if (strtoupper(date("D", $arrive)) == "SAT")
              $arrive += (2 * 86400);
            elseif (strtoupper(date("D", $arrive)) == "SUN")
              $arrive += 86400;

            $id = $db->f("ship_method_id");
            $qvars["$id"]["rate"] = $rate;
            $qvars["$id"]["ddate"] = $arrive;
            $qvars["$id"]["sdate"] = $ship;
          }
        }
      }
    }
    if (!$qvars) {
      $qvars = $this->default_method();
      //return false;
    }
    else {

      /* save the quote */

      $IS_quote = $qvars;
      $sess->register("IS_quote");

      /* save cart, quote, and ship to address for verification of changes */

      $IS_check = serialize($cart) . serialize($IS_quote) . $shipto_id;
      $sess->register("IS_check");

      return($qvars);
    }
  }

  /**************************************************************************
  ** name: default_method()
  ** created by: Matt Oberpriller
  ** description: Empty function where a default shipping calculation method
  **              can be defined.
  ** parameters:
  ** returns: 
  **
  ***************************************************************************/  
  function default_method() {
    $qvars =array();

    /* This method was left empty intentionaly.  It is here for the sole
     * purpose of allowing developers to insert their own method of
     * calculating shipping charges in the event that the InterShipper server
     * does not respond, or has been disabled.
     */

    return $qvars;
  }

  function get_rate($d) {
    global $ps_vendor_id;
    $db = new ps_DB;
    $prices = array();

    $q  = "SELECT * FROM ISshipping ";
    $q .= "WHERE ship_publish='Y' ";
    $q .= "AND vendor_id='$ps_vendor_id' ";
    $q .= "ORDER BY ship_carrier_name ASC";
    $db->query($q);

    $ship_method_id = $d["ship_method_id"];

    $prices = $this->fetch_quote($d);
    while ($db->next_record()) {
        reset($prices);
        while (list($key,$val)=each($prices)) {
           if (strcmp($key,$db->f("ship_method_id")) == 0) {
              if ($ship_method_id && (strcmp($ship_method_id,$db->f("ship_method_id")) == 0)) {
                 return $prices[$key]["rate"];
              }
           }
        }
    }
  }


}
?>
