#
# Table structure for table 'shipping_method'
#
DROP TABLE ISshipping;

CREATE TABLE ISshipping (
  ship_method_id int(11) DEFAULT '0' NOT NULL auto_increment,
  ship_carrier_id varchar(12),
  ship_carrier_code varchar(11),
  ship_carrier_name varchar(32),
  ship_method_code varchar(11) NOT NULL,
  ship_method_name varchar(32),
  ship_publish char(1),
  ship_handling_charge decimal(4,2),
  ship_handling_type char(1),
  ship_lead_time int(3),
  ship_heavy char(1),
  ship_msg_header text,
  ship_msg_footer text,
  cdate int(11),
  mdate int(11),
  vendor_id int(11) NOT NULL,
  PRIMARY KEY (ship_method_id)
);

INSERT INTO module (module_id,module_name,module_description,module_perms,module_header,module_footer,module_publish,list_order,language_code_1,language_file_1,module_label_1)
VALUES ('12837','ISshipping', '<p>Configure Your shipping methods here.</p>', 'admin,storeadmin','header.ihtml', 'footer.ihtml', 'Y', '10', 'EN', 'lang_en.inc', 'Shipping');

INSERT INTO function (module_id,function_name,function_class,function_method,function_description,function_perms)
VALUES ('12837', 'shipUpdate', 'ps_ISship', 'update', 'Updates shipping methods with shipping form changes.','admin,storeadmin');

INSERT INTO function (module_id,function_name,function_class,function_method,function_description,function_perms)
VALUES ('12837', 'shipQuote', 'ps_ISship', 'fetch_quote', '', 'admin,storeadmin,demo,shopper');

INSERT INTO function (module_id,function_name,function_class,function_method,function_description,function_perms)
VALUES ('12837', 'shipRefresh', 'ps_ISship', 'refresh', 'Deletes database of shipping methods and restores it with the latest available shipping methods from InterShipper.', 'admin');
