<?php
/*
 * ps_html Class
 *
 * Copyright (c) Edikon Corporation.  All rights reserved.
 * Distributed under the phpShop Public License (pSPL) Version 1.0.
 *
 * $Id: ps_html.inc,v 1.5 2001/01/11 00:02:59 reallost1 Exp $
 *
 */

class ps_html {
  var $classname = "ps_html";

  /**************************************************************************
  ** name: dropdown_display()
  ** created by: gday
  ** description:  Print an HTML dropdown box named $name using $arr to
  **               load the drop down.  If $value is in $arr, then $value
  **               will be the selected option in the dropdown.
  ** parameters: $name - name of the HTML dropdown element
  **             $value - Drop down item to make selected
  **             $arr - array used to build the HTML drop down element
  ** returns: prints HTML drop down element to standard output
  ***************************************************************************/
   function dropdown_display($name, $value, $arr) {

      echo "<SELECT NAME=\"$name\" SIZE=\"1\">\n";

      while (list($key, $val) = each($arr)) {
         if(strcmp($value, $key) == 0) {
            echo "<OPTION VALUE=\"$key\" SELECTED>$val\n";
         }
         else {
            echo "<OPTION VALUE=\"$key\">$val\n";
         }
      }

      echo "</SELECT>\n";

      return True;
   }


  /**************************************************************************
  ** name: list_month($list_name)
  ** created by: pfmartin
  ** description:  Print an HTML dropdown box for the credit cards 
  ** parameters: $name - name of the HTML dropdown element
  **             $value - Drop down item to make selected
  **             $arr - array used to build the HTML drop down element
  ** returns: prints HTML drop down element to standard output
  ***************************************************************************/
   function list_month($list_name) {
       $list = array("MONTH",
                    "1" => "January",
                    "2" => "February",
                    "3" => "March",
                    "4" => "April",
                    "5" => "May",
                    "6" => "June",
                    "7" => "July",
                    "8" => "August",
                    "9" => "September",
                    "10" => "October",
                    "11" => "November",
                    "12" => "December");
       $this->dropdown_display($list_name, "", $list);
       return 1;
   }


  /**************************************************************************
  ** name: list_year($list_name)
  ** created by: pfmartin
  ** description:  Print an HTML dropdown box for the credit cards
  ** parameters: $name - name of the HTML dropdown element
  **             $value - Drop down item to make selected
  **             $arr - array used to build the HTML drop down element
  ** returns: prints HTML drop down element to standard output
  ***************************************************************************/
   function list_year($list_name) {
       $list = array("YEAR",
                    "2001" => "2001",
                    "2002" => "2002",
                    "2003" => "2003",
                    "2004" => "2004",
                    "2005" => "2005",
                    "2006" => "2006",
                    "2007" => "2007",
                    "2008" => "2008",
                    "2009" => "2009");
       $this->dropdown_display($list_name, "", $list);
       return 1;
   }


  /**************************************************************************
  ** name: list_weight_uom($list_name)
  ** created by: pfmartin
  ** description:  Print an HTML dropdown box for the weight uom's
  ** parameters: $name - name of the HTML dropdown element
  **             $value - Drop down item to make selected
  **             $arr - array used to build the HTML drop down element
  ** returns: prints HTML drop down element to standard output
  ***************************************************************************/
   function list_weight_uom($list_name) {
       $list = array("-",
                    "LBS" => "Pounds",
                    "KGS" => "Kilograms",
                    "G" => "Grams");
       $this->dropdown_display($list_name, "", $list);
       return 1;
   }



  /**************************************************************************
  ** name: list_country($list_name)
  ** created by: pfmartin
  ** description:  Print an HTML dropdown box for the countries
  ** parameters: $name - name of the HTML dropdown element
  **             $value - Drop down item to make selected
  **             $arr - array used to build the HTML drop down element
  ** returns: prints HTML drop down element to standard output
  ***************************************************************************/
   function list_country($list_name, $value="") {
     $db = new ps_DB;
     
     $q = "SELECT * from country ORDER BY country_name ASC";
     $db->query($q);
     echo "<SELECT NAME=$list_name>\n";
     echo "<OPTION VALUE=\"\"> - </OPTION>\n";
     while ($db->next_record()) {
       echo "<OPTION VALUE=" . $db->f("country_3_code");
       if ($value == $db->f("country_3_code")) {
	 echo " SELECTED";
       }
       echo ">" . $db->f("country_name") . "</OPTION>\n";
     }
     echo "</SELECT>\n";
     return True;
   }
   
  /**************************************************************************
  ** name: list_currency($list_name, $value)
  ** created by: pfmartin
  ** description:  Print an HTML dropdown box for the countries
  ** parameters: $name - name of the HTML dropdown element
  **             $value - Drop down item to make selected
  **             $arr - array used to build the HTML drop down element
  ** returns: prints HTML drop down element to standard output
  ***************************************************************************/
   function list_currency($list_name, $value="") {
     $db = new ps_DB;
     
     $q = "SELECT * from currency ORDER BY currency_name ASC";
     $db->query($q);
     echo "<SELECT NAME=$list_name>\n";
     echo "<OPTION VALUE=\"\"> - </OPTION>\n";
     while ($db->next_record()) {
       echo "<OPTION VALUE=" . $db->f("currency_code");
       if ($value == $db->f("currency_code")) {
	 echo " SELECTED";
       }
       echo ">" . $db->f("currency_name") . "</OPTION>\n";
     }
     echo "</SELECT>\n";
     return True;
   }

  /**************************************************************************
  ** name: list_language($list_name, $value)
  ** created by: pfmartin
  ** description:  Print an HTML dropdown box for the countries
  ** parameters: $name - name of the HTML dropdown element
  **             $value - Drop down item to make selected
  **             $arr - array used to build the HTML drop down element
  ** returns: prints HTML drop down element to standard output
  ***************************************************************************/
   function list_language($list_name, $value="") {
     $db = new ps_DB;
     
     $q = "SELECT * from language ORDER BY language_name ASC";
     $db->query($q);
     echo "<SELECT NAME=$list_name>\n";
     echo "<OPTION VALUE=\"\"> - </OPTION>\n";
     while ($db->next_record()) {
       echo "<OPTION VALUE=" . $db->f("language_code");
       if ($value == $db->f("language_code")) {
	 echo " SELECTED";
       }
       echo ">" . $db->f("language_name") . " - (" . $db->f("language_code") . ")</OPTION>\n";
     }
     echo "</SELECT>\n";
     return True;
   }
}
 
?>
