<?php
/*
 * The ps_user class
 *
 * Copyright (c) Edikon Corporation.  All rights reserved.
 * Distributed under the phpShop Public License (pSPL) Version 1.0.
 *
 * $Id: ps_user.inc,v 1.6 2000/09/07 02:52:23 pfmartin Exp $
 *
 */


class ps_user {
  var $classname = "ps_user";
  
  /**************************************************************************
  ** name: validate_add()
  ** created by:
  ** description:
  ** parameters:
  ** returns:
  ***************************************************************************/
  function validate_add(&$d) {
    $valid = true;
    
    if (!$d["last_name"]) {
      $d["error"] .= "'Last Name' is a required field.<br>";
      $valid = false;
    }
    if (!$d["first_name"]) {
      $d["error"] .= "'First Name' is a required field.<br>";
      $valid = false;
    }
    if (!$d["username"]) {
      $d["error"] .= "'Username' is a required field.<br>";
      $valid = false;
    }
    if (!eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*$", $d["username"])) {
      $d["error"] .= "'Username' cannot contain spaces.<br>";
      $valid = false;
    }
  
    if (!$d["password_1"]) {
      $d["error"] .= "'Password' is a required field.<br>";
      $valid = false;
    }
    if ($d["password_1"] != $d["password_2"]) {
      $d["error"] .= "The passwords entered do not match.<br>";
      $valid = false;
    }
//    if (!$d["perms"]) {
//      $d["error"] .= "You must assign the user to a group.<br>";
//      $valid = false;
//    }
    if (!$d["user_email"]) {
      $d["error"] .= "'Email' is a required field.<br>";
      $valid = false;
    } 
    elseif (!validate_email($d["user_email"])) {
      $d["error"] .= "Please provide a valid email address.<br>";
      $valid = false;
    }
    $db = new ps_DB;
    $q = "SELECT * from auth_user_md5 where username='" .  $d["username"] . "'";
    $db->query($q);
    if ($db->next_record()) {
      $d["error"] .= "The given username already exists.  ";
      $d["error"] .= "Please try another username.<br>";
      $valid = false;
    }
    return $valid;
  }
  
  /**************************************************************************
  ** name: validate_delete()
  ** created by:
  ** description:
  ** parameters:
  ** returns:
  ***************************************************************************/
  function validate_delete(&$d) {

    if (!$d["user_id"]) {
      $d["error"] .= "Please select a user to delete.";
      return False;
    }
    else {
      return True;
    }
  }

  /**************************************************************************
  ** name: validate_update()
  ** created by:
  ** description:
  ** parameters:
  ** returns:
  ***************************************************************************/
  function validate_update(&$d) {
    $valid = true;
    
    if (!$d["last_name"]) {
      $d["error"] .= "'Last Name' is a required field.<br>";
      $valid = false;
    }
    if (!$d["first_name"]) {
      $d["error"] .= "'First Name' is a required field.<br>";
      $valid = false;
    }
    if (!$d["username"]) {
      $d["error"] .= "'Username' is a required field.<br>";
      $valid = false;
    }
     if (!eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*$", $d["username"])) {
      $d["error"] .= "'Username' cannot contain spaces.<br>";
      $valid = false;
    }
   if ($d["password_1"] != $d["password_2"]) {
      $d["error"] .= "The passwords entered do not match.<br>";
      $valid = false;
    }
    if (!$d["user_email"]) {
      $d["error"] .= "'Email' is a required field.<br>";
      $valid = false;
    }
    if (!validate_email($d["user_email"])) {
      $d["error"] .= "Please provide a valid email address.<br>";
      $valid = false;
    }
    return $valid;
  }
  
  
  /**************************************************************************
   * name: add()
   * created by:
   * description:
   * parameters:
   * returns:
   **************************************************************************/
  function add(&$d) {
    global $ps_vendor_id;
    $hash_secret = "PHPShopIsCool";
    $db = new ps_DB;
    $timestamp = time();
    
    if (!$this->validate_add($d)) {
      return False;
    }
    
    $user_id=md5(uniqid($hash_secret));
    
    $q = "INSERT INTO auth_user_md5 (user_id,username,password, perms) ";
    $q .= "VALUES ('";
    $q .= $user_id . "','";
    $q .= $d["username"] . "','";
    $q .= md5($d["password_1"]) . "','";
    $q .= $d["perms"] . "')";
    $db->query($q);
 
    if (USER_INFO_XF_4 and $d["extra_field_4"] == "") {
      $d["extra_field_4"] = "N";
    }
    if (USER_INFO_XF_5 and $d["extra_field_5"] == "") {
      $d["extra_field_5"] = "N";
    } 
    
    // Insert billto
    $q = "INSERT INTO user_info (user_id,address_type,address_type_name,";
    $q .= "company,title,last_name,first_name,middle_name,";
    $q .= "phone_1,phone_2,fax,address_1,";
    $q .= "address_2,city,state,country, zip,";
    $q .= "user_email,extra_field_1,extra_field_2,extra_field_3,";
    $q .= "extra_field_4,extra_field_5,cdate,mdate) VALUES ";
    $q .= "('$user_id','";
    $q .= $d["address_type"] . "','";
    $q .= $d["address_type_name"] . "','";
    $q .= $d["company"] . "','";
    $q .= $d["title"] . "','";
    $q .= $d["last_name"] . "','";
    $q .= $d["first_name"] . "','";
    $q .= $d["middle_name"] . "','";
    $q .= $d["phone_1"] . "','";
    $q .= $d["phone_2"] . "','";
    $q .= $d["fax"] . "','";
    $q .= $d["address_1"] . "','";
    $q .= $d["address_2"] . "','";
    $q .= $d["city"] . "','";
    $q .= $d["state"] . "','";
    $q .= $d["country"] . "','";
    $q .= $d["zip"] . "','";
    $q .= $d["user_email"] . "','";
    $q .= $d["extra_field_1"] . "','";
    $q .= $d["extra_field_2"] . "','";
    $q .= $d["extra_field_3"] . "','";
    $q .= $d["extra_field_4"] . "','";
    $q .= $d["extra_field_5"] . "','";
    $q .= $timestamp . "','";
    $q .= $timestamp . "') ";
    $db->query($q);
    
    // Insert vendor relationship
    $q = "INSERT INTO auth_user_vendor (user_id,vendor_id)";
    $q .= " VALUES ";
    $q .= "('" . $user_id . "','";
    $q .= $ps_vendor_id . "') ";
    $db->query($q);
    
    return True;
    
  }
  
  /**************************************************************************
   * name: update()
   * created by:
   * description:
   * parameters:
   * returns:
   **************************************************************************/
  function update(&$d) {
    global $ps_vendor_id;
    $db = new ps_DB;
    $timestamp = time();
    
    if (!$this->validate_update($d)) {
      return False;
    }
    
    if ($d["password_1"]) {
      $d["password_1"] = md5($d["password_1"]);
      $q  = "UPDATE auth_user_md5 SET ";
      $q .= " password='" . $d["password_1"];
      $q .= "', perms='" . $d["perms"] . "', ";
      $q .= "username='" . $d["username"] . "' ";
      $q .= "WHERE user_id='" . $d["user_id"] . "'";      
      $db->query($q);
    }
    else {
      $q  = "UPDATE auth_user_md5 SET ";
      $q .= "perms='" . $d["perms"] . "', ";
      $q .= "username='" . $d["username"] . "' ";
      $q .= "WHERE user_id='" . $d["user_id"] . "'";      
      $db->query($q);
    }

    if (USER_INFO_XF_4 and $d["extra_field_4"] == "") {
      $d["extra_field_4"] = "N";
    }
    if (USER_INFO_XF_5 and $d["extra_field_5"] == "") {
      $d["extra_field_5"] = "N";
    }
    
    /* Update Bill To */
    $q  = "UPDATE user_info SET ";
    $q .= "company='" . $d["company"] . "', ";
    $q .= "address_type='" . $d["address_type"] . "', ";
    $q .= "address_type_name='" . $d["address_type_name"] . "', ";
    $q .= "title='" . $d["title"] . "', ";
    $q .= "last_name='" . $d["last_name"] . "', ";
    $q .= "first_name='" . $d["first_name"] . "', ";
    $q .= "middle_name='" . $d["middle_name"] . "', ";
    $q .= "phone_1='" . $d["phone_1"] . "', ";
    $q .= "phone_2='" . $d["phone_2"] . "', ";
    $q .= "fax='" . $d["fax"] . "', ";
    $q .= "address_1='" . $d["address_1"] . "', ";
    $q .= "address_2='" . $d["address_2"] . "', ";
    $q .= "city='" . $d["city"] . "', ";
    $q .= "state='" . $d["state"] . "', ";
    $q .= "country='" . $d["country"] . "', ";
    $q .= "zip='" . $d["zip"] . "', ";
    $q .= "user_email='" . $d["user_email"] . "', ";
    $q .= "extra_field_1='" . $d["extra_field_1"] . "', ";
    $q .= "extra_field_2='" . $d["extra_field_2"] . "', ";
    $q .= "extra_field_3='" . $d["extra_field_3"] . "', ";
    $q .= "extra_field_4='" . $d["extra_field_4"] . "', ";
    $q .= "extra_field_5='" . $d["extra_field_5"] . "', ";
    $q .= "mdate='" . $timestamp . "' "; 
    $q .= "WHERE user_id='" . $d["user_id"] . "' AND ";
    $q .= "address_type='BT'";
    $q .= $q_end;
    $db->query($q);

    $q = "UPDATE auth_user_vendor set ";
    $q .= "vendor_id='$ps_vendor_id' ";
    $q .= "WHERE user_id='" . $d["user_id"] . "'";
    $db->query($q);

    return True;
  }
  
  /**************************************************************************
   * name: update_admin_passwd()
   * created by:
   * description:
   * parameters:
   * returns:
   **************************************************************************/
  function update_admin_passwd(&$d) {
    global $auth;
    $db = new ps_DB;

    $q  = "SELECT password from auth_user_md5 ";
    $q .= "WHERE user_id='" . $auth["user_id"] . "'";      
    $db->query($q);
    $db->next_record();
    if (md5($d["password_curr"]) != $db->f("password")) { 
      $d["error"] = "The current password entered does not match.";
      return false;
    }
    if ($d["password_1"] != $d["password_2"]) {
      $d["error"] = "The new passwords entered do not match.";
      return false;		
    }
    
    if ($d["password_1"] == $d["password_2"]) {
      $d["password_1"] = md5($d["password_1"]);
      $q  = "UPDATE auth_user_md5 ";
      $q .= "SET password='" . $d["password_1"] . "' ";
      $q .= "WHERE user_id='" . $auth["user_id"] . "'";      
      $db->query($q);
    }
    
    return True;
  }

  /**************************************************************************
   * name: delete()
   * created by:
   * description:
   * parameters:
   * returns:
   **************************************************************************/
  function delete(&$d) {
    $db = new ps_DB;
    
    if (!$this->validate_delete($d)) {
      return False;
    }
    
    $q = "DELETE from auth_user_md5 where user_id='" . $d["user_id"] . "'";
    $db->query($q);
    $db->next_record();
    
    $q = "DELETE from user_info where user_id='" . $d["user_id"] . "'";
    $db->query($q);
    $db->next_record();

    // Delete auth_user_vendor entries
    $q = "DELETE from auth_user_vendor where user_id='" . $d["user_id"] . "'";
    $db->query($q);
    $db->next_record();

    return True;
  }
  
  
  /**************************************************************************
   * name: list_perms()
   * created by: pablo
   * description: lists the permission in a select box
   * parameters:
   * returns:
   **************************************************************************/
  function list_perms($name,$group_name) {
    global $perm;
    global $auth;
    $db = new ps_DB;
  
    // Get users current permission value 
    $dvalue = $perm->permissions[$auth["perms"]];
    echo "<SELECT NAME=$name>\n";
    echo "<OPTION VALUE=\"0\">Please Select</OPTION>\n";
    while (list($key,$value) = each($perm->permissions)) {
      // Display only those permission that this user can set
      if ($value <= $dvalue)
      if ($key == $group_name) {
	echo "<OPTION VALUE=$key SELECTED>$key</OPTION>\n";
      }
      else {
	echo "<OPTION VALUE=$key>$key</OPTION>\n";
      }
    }
    echo "</SELECT>\n";
  }        

  /**************************************************************************
   * name: logout()
   * created by:
   * description:
   * parameters:
   * returns:
   **************************************************************************/
  function logout(&$d) {
    global $auth, $sess;
    
    $auth["uid"]="";
    $auth["user_id"]="";
    $auth["uname"]="";
    $auth["username"]="";
    $auth["perm"]="";
    $auth["perms"]="";
    $sess->destroy();
    return True;   
  }

  /**************************************************************************
   * name: logout()
   * created by:
   * description:
   * parameters:
   * returns:
   **************************************************************************/
  function logged_in() {
    global $auth;
    
    if ($auth["perms"]) {
      return True;   
    }
    else return False;
  }

  /**************************************************************************
   * name: login()
   * created by:
   * description:
   * parameters:
   * returns:
   **************************************************************************/
  function login(&$d) {
    global $auth, $sess, $ps_vendor_id;
    $db = new ps_DB;

    $q = "SELECT * from auth_user_md5,user_info ";
    $q .= "WHERE auth_user_md5.username ='" . $d["username"] . "' ";
    $q .= "AND auth_user_md5.password ='" . md5($d["password"]) . "'";
    $q .= "AND auth_user_md5.password ='" . md5($d["password"]) . "'";
    $q .= "AND auth_user_md5.user_id = user_info.user_id ";
    $q .= "AND user_info.address_type = 'BT'";

    $db->query($q);

    if ($db->next_record()) {
      $auth["user_id"]   = $db->f("user_id");
      $auth["username"] = $d["username"];
      $auth["perms"]  = $db->f("perms");
      $auth["first_name"] = $db->f("first_name");
      $auth["last_name"] = $db->f("last_name");
    }
    else {
      $d["error"] = "The username and password you entered were not found.<BR>";
      $d["error"] .= "Please try again.";
      $d["login"]="1";
      return False;
    }

    $q = "SELECT * from vendor";
    $db->query($q);
    if ($db->next_record()) {
       $ps_vendor_id=$db->f("vendor_id");
       $sess->register("ps_vendor_id");
    }
    $d["login"] = "0";
    return $auth["user_id"];

  }

  
}

?>
