<?php
/*
 *
 * Copyright (c) Edikon Corporation.  All rights reserved.
 * Distributed under the phpShop Public License (pSPL) Version 1.0.
 *
 * $Id: ps_cart.inc,v 1.3 2000/09/03 16:01:54 pfmartin Exp $
 *
*
* CLASS DESCRIPTION
*                   
* ps_cart
*
* The cart class is used to store products and carry them through the user's
* session in the store.
* propeties:  
* 	item() - an array of items
*       idx - the current count of items in the cart
*       error - the error message returned by validation if any
* methods:
*       add()
*       update()
*       delete()
*	
*
*************************************************************************/
class ps_cart {
  var $classname="ps_cart";


  /**************************************************************************
  ** name: add()
  ** created by: pablo
  ** description: adds an item to the shopping cart
  ** parameters:
  ** returns:
  ***************************************************************************/  
  function add(&$d) {
    global $cart;

    $db = new ps_DB;
    $product_id = $d["product_id"];
    $quantity = $d["quantity"];

    // Check for negative quantity
    if ($quantity < 0) {
      $d["error"] = "Negative quantities are not allowed.";
      return False;
    }

    if (!ereg("^[0-9]*$", $quantity)) {
     	$d["error"] = "Please enter a valid quantity for this item.";
        return False; 
    }

    // Check to see if checking stock quantity
    if (CHECK_STOCK) {
      $q = "SELECT product_in_stock ";
      $q .= "FROM product where product_id=";
      $q .= $product_id;
      $db->query($q);
      $db->next_record();
      $product_in_stock = $db->f("product_in_stock");
      if ($quantity > $product_in_stock) {
	$d["error"] = "Quantity selected exceeds available stock.<BR>";
	$d["error"] .= "Currently have $product_in_stock items available.";
	return False;
      }
    }

    // Quick add of item
    if ($d["product_id"]=="0") {
      $d["error"] = "Please select a color.";
      return False;
    } 

    // If no quantity sent them assume 1
    if ($quantity == "")
      $quantity = 1;
    // Check to see if we already have it

    $updated = 0;
    // Check for duplicate and do not add to current quantity
    for ($i=0;$i<$cart["idx"];$i++) {
      if ($cart[$i]["product_id"] == $product_id) {
	$updated = 1;
      }
    }
    // If we did not update then add the item
    if (!$updated) {
      $cart[$cart["idx"]]["quantity"] = $quantity;
      $cart[$cart["idx"]]["product_id"] = $product_id;
      $cart["idx"]++;
    }
    return True; 
  }

 /**************************************************************************
  ** name: update()
  ** created by: pablo
  ** description: updates the quantity of a product_id in the cart
  ** parameters:
  ** returns:
  ***************************************************************************/    
  function update(&$d) {
    global $cart;

    $db = new ps_DB;
    $product_id = $d["product_id"];
    $quantity = $d["quantity"];

    // Check for negative quantity
    if ($quantity < 0) {
      $d["error"] = "Negative quantities are not allowed.";
      return False;
    }

    if (!ereg("^[0-9]*$", $quantity)) {
        $d["error"] = "Please enter a valid quantity for this item.";
        return False;
    }

    // Check to see if checking stock quantity
    if (CHECK_STOCK) {
      $q = "SELECT product_in_stock ";
      $q .= "FROM product where product_id=";
      $q .= $product_id;
      $db->query($q);
      $db->next_record();
      $product_in_stock = $db->f("product_in_stock");
      if ($quantity > $product_in_stock) {
	$d["error"] = "Quantity selected exceeds available stock.<BR>";
	$d["error"] .= "Currently have $product_in_stock items available.";
	return False;
      }
    }

    if (!$product_id) {
      return False;
    }

    if ($quantity == 0) {
	$this->delete($d);
    }
    else {
      for ($i=0;$i<$cart["idx"];$i++) {
        if ($cart[$i]["product_id"] == $product_id) {
	  $cart[$i]["quantity"] = $quantity;
        }
      }
    }
    return True;
  }
  
 /**************************************************************************
  ** name: delete()
  ** created by: pablo
  ** description: deletes a given product_id from the cart
  ** parameters:
  ** returns:
  ***************************************************************************/    
  function delete($d) {
    global $cart;
    $temp = array();
    $product_id = $d["product_id"];

    if (!$product_id) {
      return False;
    }
 
    $j = 0;
    for ($i=0;$i<$cart["idx"];$i++) {
      if ($cart[$i]["product_id"] != $product_id) {
	$temp[$j++] = $cart[$i];
      }
    }
    $temp["idx"] = $j;
    $cart = $temp;
    return True;
  } 


 /**************************************************************************
  ** name: reset()
  ** created by: pablo
  ** description: resets the cart (i.e. empty)
  ** parameters:
  ** returns:
  ***************************************************************************/    
  function reset() { 
    global $cart;
    $cart["idx"]=0;
    return True;
  }
}

?>
